/*
 * @(#)ObjectModel.java  1.0  5. Februar 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.objectmodel;

import ch.hslu.cm.simulation.*;
import java.util.*;
/**
 * Simulates an object model.
 *
 * @author  Werner Randelshofer
 * @version 1.0 5. Februar 2004  Created.
 */
public class ObjectModel extends AbstractSimulation {
    /**
     * Enumeration of simulated concepts.
     */
    public final static int OBJECT = 0;
    public final static int CLASS = 1;
    public final static int ASSOCIATION = 2;
    public final static int LINK = 3;
    public final static int GENERALIZATION = 4;
    public final static int DEPENDENCY = 5;
    
    /** Creates a new instance. */
    public ObjectModel() {
    }
    
    public OMClass getSimulatedClass(String className) {
        // FIXME - Linear search!!
        // This is very slow, we should consider using hash maps for all
	// names 
        
       for (Iterator i = getElements().iterator(); i.hasNext(); ) {
           SimulatedElement elem = (SimulatedElement) i.next();
           if (elem.getSimulatedConcept() == CLASS) {
               OMClass clazz = (OMClass) elem;
               if (clazz.getName().equals(className)) {
                   return clazz;
               }
           }
       }
       
       return null;
    }
    public OMObject getSimulatedObject(String objectName) {
        // FIXME - Linear search!!
        // This is very slow, we should consider using hash maps for all
	// names 
        
       for (Iterator i = getElements().iterator(); i.hasNext(); ) {
           SimulatedElement elem = (SimulatedElement) i.next();
           if (elem.getSimulatedConcept() == OBJECT) {
               OMObject o = (OMObject) elem;
               if (o.getName().equals(objectName)) {
                   return o;
               }
           }
       }
       
       return null;
    }
    
    public Collection getSimulatedClasses() {
        LinkedList<OMClass> result = new LinkedList<OMClass>();
        
       for (Iterator i = getElements().iterator(); i.hasNext(); ) {
           SimulatedElement elem = (SimulatedElement) i.next();
           if (elem.getSimulatedConcept() == CLASS) {
               result.add((OMClass) elem);
           }
       }
       
        Collections.sort(result, new OMClassNameComparator());
        
       return result;
    }
    
    public SimulatedObject create(int simulatedConcept) {
        SimulatedObject elem;
        switch (simulatedConcept) {
            case OBJECT :
                elem = new OMObject();
                break;
            case CLASS :
                elem = new OMClass();
                break;
            case ASSOCIATION :
                elem = new OMAssociation();
                break;
            case LINK :
                elem = new OMLink();
                break;
            case GENERALIZATION :
                elem = new OMGeneralization();
                break;
            case DEPENDENCY :
                elem = new OMDependency();
                break;
            default :
                throw new IllegalArgumentException(simulatedConcept+"");
        }
        return elem;
    }
    
    /**
     * Unwraps a text representation of an attribute value into an object.
     */
    public Object unwrapValue(String text) {
        Object value;
        if (text == null || text.length() == 0 || text.equals("null")) {
            value = null;
        } else {
            Double number;
            try {
                number = Double.valueOf(text);
            } catch (NumberFormatException e) {
                number = null;
            }
            if (number != null) {
                value = number;
            } else if (text.charAt(0) == '"' || text.charAt(0) == '\'') {
                value = text.substring(1, text.length() - 1);
            } else {
                // value is a pointer to another simulated object
                // or simulated class.
                value = text;
                for (Iterator i=getElements().iterator(); i.hasNext(); ) {
                    SimulatedElement element = (SimulatedElement) i.next();
                    if (element.getName() != null && element.getName().equals(text)) {
                        value = element;
                        break;
                    }
                }
            }
        }
        return value;
    }
    /**
     * Wraps an attribute value into a text presentation.
     */
    public String wrapValue(Object value) {
        String text;
        if (value != null && (value instanceof String)) {
            text = "\""+value+"\"";
        } else if (value instanceof Number) {
            text = ""+value;
            
            // We don't want trailing '.0' in numbers. It looks awkward.
            if (text.length() > 2 && text.endsWith(".0")) {
                text = text.substring(0, text.length() - 2);
            }
        } else {
            text = ""+value;
        }
        return text;
    }
    
}